import java.io.IOException;
import java.util.ArrayList;

public class Bank extends FinancialInstitution {
	private static int numBanks = 1;
	private String name         = new String();
	private double assets;

	/** Creates a new instance of Bank with name n, assets a **/
	public Bank(String n, double a) {
		super();
		++numBanks;
		name = n;
		assets = a;
		
	}
	
	/** Creates a new instance of Bank with name "Bank#" and assets a **/
	public Bank( double a ) {
		this ("Bank" + numBanks, a);
	}
	
	/** Creates a new instance of Bank with name "Bank#" and assets 1000000 **/
	public Bank() {
		this("Bank" + numBanks, 1000000);
	}
	
	/** String representation of this bank **/
	public String toString() {
		return "Bank " + name + " has total assets of $" + assets + " and holds " + getAccounts().size() + " accounts belonging to " + getCustomers().size() + " customers.";
	}
	
	/** Sets the banks assets to val **/
	public void setAssets(int val) {
		assets = val;
	}
	
	/** = assets of this bank. **/
	public double getAssets() {
		return assets;
	}
	
	/** Creates a new account at this bank. type takes a 0 for savings account or 1 for checking account.
	 * It also requires the owner of the account and the initial value to place in the account.
	 * It withdraws the money from the owner.
	 * @throws IOException 
	 **/
	public Account createAccount(int type, Person owner, double value) throws IOException {
		if (! owner.requestPassword()) {
			return null;
		}
		
		// create the account
		Account ac;
		ArrayList<Account> accounts  = getAccounts();
		ArrayList<Person> customers = getCustomers();
		
		if (type == 0) {
			ac = new SavingsAccount(value, this, owner);
		}
		else {
			ac = new CheckingAccount(value, this, owner);
		}
		
		// add to accounts array
		accounts.add(ac);
		
		// check if this is a new customer for the bank and add them to the customer array if they are
		if (customers.indexOf(owner) == -1)
			customers.add(owner);
		
		return ac;
	}
	
	/** Closes an account at this bank.
	 * @throws IOException 
	 **/
	public boolean closeAccount(Account ac) throws IOException {
		Person owner = ac.getOwner();
		
		if (! owner.requestPassword()) {
			return false;
		}
		
		ArrayList<Account> accounts  = getAccounts();
		ArrayList<Person> customers = getCustomers();
		
		// remove from accounts array
		accounts.remove(ac);
		
		// check if the customer has any more accounts at this bank
		boolean stillCust = false;
		for (int i = 0; i<accounts.size(); ++i) {
			if (accounts.get(i).getOwner().equals(owner)) {
				stillCust = true;
				break;
			}
		}
		if (!stillCust)
			customers.remove(owner);
		
		return true;
	}


}
